#include <stdio.h>
#include <stdlib.h>

typedef long long ll;

typedef struct {
    ll x, h, idx;
} Jarbol;

int cmp(const void *a, const void *b){
    Jarbol *p1=(Jarbol*)a;
    Jarbol *p2=(Jarbol*)b;
    if(p1->x!=p2->x) return p1->x<p2->x?-1:1;
    return 0;
}

ll absll(ll a){ return a>=0?a:-a; }

int main(){
    int n;
    scanf("%d",&n);
    Jarbol *arr = malloc(n*sizeof(Jarbol));
    for(int i=0;i<n;i++){ scanf("%lld",&arr[i].x); arr[i].idx=i; }
    for(int i=0;i<n;i++) scanf("%lld",&arr[i].h);

    qsort(arr,n,sizeof(Jarbol),cmp);

    ll *res = malloc(n*sizeof(ll));
    for(int i=0;i<n;i++) res[i]=-1;

    ll *left_max = malloc(n*sizeof(ll));
    ll *left_x = malloc(n*sizeof(ll));
    left_max[0]=arr[0].h; left_x[0]=arr[0].x;
    for(int i=1;i<n;i++){
        ll dx=arr[i].x-arr[i-1].x;
        ll hpeak=(arr[i].h+arr[i-1].h+dx)/2;
        if(hpeak>arr[i-1].h) left_max[i]=hpeak; else left_max[i]=arr[i-1].h;
        left_x[i]=arr[i-1].x;
    }

    for(int i=0;i<n;i++){
        ll d=-1;
        if(arr[i].h<=arr[i].h) d=0;
        if(i>0 && arr[i].h<=left_max[i]){
            ll dx1=absll(arr[i].x-left_x[i]);
            if(d==-1 || dx1<d) d=dx1;
        }
        res[arr[i].idx]=d;
    }

    ll *right_max = malloc(n*sizeof(ll));
    ll *right_x = malloc(n*sizeof(ll));
    right_max[n-1]=arr[n-1].h; right_x[n-1]=arr[n-1].x;
    for(int i=n-2;i>=0;i--){
        ll dx=arr[i+1].x-arr[i].x;
        ll hpeak=(arr[i].h+arr[i+1].h+dx)/2;
        if(hpeak>arr[i+1].h) right_max[i]=hpeak; else right_max[i]=arr[i+1].h;
        right_x[i]=arr[i+1].x;
    }

    for(int i=0;i<n;i++){
        ll d=-1;
        if(res[arr[i].idx]!=-1) d=res[arr[i].idx];
        if(i<n-1 && arr[i].h<=right_max[i]){
            ll dx1=absll(arr[i].x-right_x[i]);
            if(d==-1 || dx1<d) d=dx1;
        }
        res[arr[i].idx]=d;
    }

    for(int i=0;i<n;i++) printf("%lld\n",res[i]);

    free(arr); free(res); free(left_max); free(left_x); free(right_max); free(right_x);
    return 0;
}